#if NUNIT
#region Directives
//-----------------------***

using System;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.UnitTests;
using System.Net;
using gov.va.med.vbecs.DAL.VAL;
using System.Reflection;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***

#endregion

namespace gov.va.med.vbecs.UnitTest.VAL
{
	/// <summary>
	/// Unit test wrapper for VistALink. Provides re-enterable VistALink initialization 
	/// to ensure VistALink connection availability during unit tests. 
	/// </summary>
	internal class VistALinkUnitTestHarness : BaseTest 
	{
		private static VistALinkUnitTestBinder _uiBinder = null;

		/// <summary>
		/// Test data used to test VistALink configuration tools.
		/// </summary>
		internal class TestData
		{
			public static readonly string VistAServerAppHandle = GetVistALinkConfigConst( "PrimaryServerHandle" );
			public static readonly string VistAServerAlias = GetVistALinkConfigConst( "PrimaryServerAlias" );
			public const string VistaIpAddressString = "127.0.0.1";
			public const string DomainName = "foo.com";
			public const int VistaPortNumber = 1234;
			public static readonly IPAddress VistaIpAddress = IPAddress.Parse( VistaIpAddressString );

			private static string GetVistALinkConfigConst( string constName )
			{
				return (string)typeof(BOL.VistALinkConfig).GetField( constName, BindingFlags.NonPublic | BindingFlags.Static | BindingFlags.FlattenHierarchy ).GetValue( null );
			}
		}

		/// <summary>
		/// Required to initialize VistALink and back up VistALink configuration parameters from DB to mem. 
		/// </summary>
		static VistALinkUnitTestHarness()
		{
			InitVistALink();
		}

		/// <summary>
		/// Gets VistALink config used in unit tests.
		/// </summary>
		/// <returns></returns>
		public static BOL.VistALinkConfig GetUnitTestVistALinkConfig()
		{
			return BOL.VistALinkConfig.GetCurrent();
		}

		/// <summary>
		/// Unit tests must not use this method!!! Assume VistALink is always initialized in unit tests.
		/// It must be used only to unit test VistALink class itself.
		/// 
		/// External call to this method will always fail because VistAlink is already initialized in 
		/// <see cref="VistALinkUnitTestHarness"/> static constructor.
		/// </summary>
		public static void InitVistALink()
		{
			_uiBinder = new VistALinkUnitTestBinder();

			VistALink.Initialize( GetUnitTestVistALinkConfig().GetServerConnectionInfo(), _uiBinder, UnitTestConfig.VistAUserDuz );
		}

		/// <summary>
		/// Ensures VistALink connection is available, connects if required.
		/// </summary>
		public static void RequireConnection()
		{
			if( VistALink.IsAvailable )
				return;

			if( !VistALink.Connect() )
				Assert.Fail( "Unable to connect to VistALink server. Unable to run unit test therefore." );
		}

		/// <summary>
		/// Releases VistALink connection. Does not perform actual disconnect if
		/// specified in config file.
		/// </summary>
		public static void ReleaseConnection()
		{
			if( !UnitTestConfig.DoNotReleaseVistALinkConnectionImmediately )
				VistALink.Disconnect();
		}

		/// <summary>
		/// Always disconnects VistALink.
		/// </summary>
		public static void ForcedDisconnect()
		{
			VistALink.Disconnect();
		}

		/// <summary>
		/// Empty method ensuring VistALink is initialized via static constructor.
		/// </summary>
		public static void Touch() {}


		public static VistALinkUnitTestBinder TestUiBinder
		{
			get
			{
				return _uiBinder;
			}
		}
	}
}
#endif
